/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.memory;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.console.ui.tabs.memory.AllPoolsContentProvider;
import com.jrockit.mc.console.ui.tabs.memory.MemoryPoolModel;
import com.jrockit.mc.console.ui.tabs.memory.UsageBackgroundTablePainter;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.sections.FieldTableViewerSectionPart;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MemoryPoolTableSectionPart
extends FieldTableViewerSectionPart {
    private static Field[] FIELDPROTOTYPES = new Field[]{AllPoolsContentProvider.FIELD_POOL_NAME, AllPoolsContentProvider.FIELD_POOL_TYPE, AllPoolsContentProvider.FIELD_POOL_CUR_USED, AllPoolsContentProvider.FIELD_POOL_CUR_MAX, AllPoolsContentProvider.FIELD_POOL_CUR_USAGE, AllPoolsContentProvider.FIELD_POOL_PEAK_USED, AllPoolsContentProvider.FIELD_POOL_PEAK_MAX};
    private final MemoryPoolModel m_poolModel;

    public MemoryPoolTableSectionPart(Composite parent, FormToolkit toolkit, MemoryPoolModel poolModel, String sectionIdetifier) {
        super(parent, toolkit, 450, sectionIdetifier, FIELDPROTOTYPES, ConsolePlugin.getDefault().getMCDialogSettings());
        this.setHelpContextID("com.jrockit.mc.console.ui.MemoryPoolTableSectionPart");
        this.m_poolModel = poolModel;
        this.m_poolModel.addObserver(this.createObserver());
    }

    private Observer createObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                final FieldTableViewer tableViewer = MemoryPoolTableSectionPart.this.getTableViewer();
                if (tableViewer != null) {
                    DisplayToolkit.safeAsyncExec((Widget)tableViewer.getTable(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            tableViewer.refresh();
                        }
                    });
                }
            }
        };
    }

    protected MemoryPoolModel getModel() {
        return this.m_poolModel;
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.PoolTableSectionPart_SECTION_TEXT);
        section.setDescription(Messages.PoolTableSectionPart_DESCRIPTION_TEXT);
        section.setData("name", (Object)"threads.ThreadsTab.AllPoolsTable");
    }

    protected void initializePart() {
        super.initializePart();
        this.getTableViewer().setContentProvider((IContentProvider)new AllPoolsContentProvider());
        this.getTableViewer().setInput((Object)this.getModel());
        this.getTableViewer().getTable().addListener(40, (Listener)new UsageBackgroundTablePainter(this.getFields()));
    }
}

