/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.options;

import com.sun.tools.visualvm.core.datasupport.ComparableWeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public final class GlobalPreferences
implements PreferenceChangeListener {
    private static final Logger LOGGER = Logger.getLogger("com.sun.tools.visualvm.core.options");
    private static final String INT_KEY_MONHOST_POLL = "MonitoredHostPoll";
    private static final String INT_KEY_THREADS_POLL = "ThreadsPoll";
    private static final String INT_KEY_MONDATA_POLL = "MonitoredDataPoll";
    private static final String INT_KEY_MONHOST_CACHE = "MonitoredHostCache";
    private static final String INT_KEY_MONDATA_CACHE = "MonitoredDataCache";
    private static final int MONHOST_POLL_DEFAULT = 3;
    private static final int THREADS_POLL_DEFAULT = 1;
    private static final int MONDATA_POLL_DEFAULT = 1;
    private static final int MONHOST_CACHE_DEFAULT = 60;
    private static final int MONDATA_CACHE_DEFAULT = 60;
    private static final GlobalPreferences INSTANCE = new GlobalPreferences();
    private final Preferences prefs;
    private final Map<String, Set<ComparableWeakReference<PreferenceChangeListener>>> listenerMap = new HashMap<String, Set<ComparableWeakReference<PreferenceChangeListener>>>();
    private final ExecutorService dispatcher = Executors.newCachedThreadPool();

    private GlobalPreferences() {
        this.prefs = NbPreferences.forModule(GlobalPreferences.class);
        this.prefs.addPreferenceChangeListener(this);
    }

    public static GlobalPreferences sharedInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preferenceChange(final PreferenceChangeEvent evt) {
        Map<String, Set<ComparableWeakReference<PreferenceChangeListener>>> map = this.listenerMap;
        synchronized (map) {
            Set<ComparableWeakReference<PreferenceChangeListener>> set = this.listenerMap.get(evt.getKey());
            if (set != null) {
                final HashSet tmpListeners = new HashSet();
                ArrayList<ComparableWeakReference<PreferenceChangeListener>> deadRefs = new ArrayList<ComparableWeakReference<PreferenceChangeListener>>();
                for (ComparableWeakReference<PreferenceChangeListener> pclRef : set) {
                    if (pclRef.get() != null) {
                        tmpListeners.add(pclRef.get());
                        continue;
                    }
                    deadRefs.add(pclRef);
                }
                set.removeAll(deadRefs);
                this.dispatcher.submit(new Runnable(){

                    public void run() {
                        for (PreferenceChangeListener pcl : tmpListeners) {
                            pcl.preferenceChange(evt);
                        }
                    }
                });
            }
        }
    }

    public int getMonitoredHostPoll() {
        return this.getPollingInterval(INT_KEY_MONHOST_POLL, 3);
    }

    public void setMonitoredHostPoll(int value) {
        this.setPollingInterval(INT_KEY_MONHOST_POLL, value);
    }

    public void watchMonitoredHostPoll(PreferenceChangeListener pcl) {
        this.addListener(INT_KEY_MONHOST_POLL, pcl);
    }

    public int getThreadsPoll() {
        return this.getPollingInterval(INT_KEY_THREADS_POLL, 1);
    }

    public void setThreadsPoll(int value) {
        this.setPollingInterval(INT_KEY_THREADS_POLL, value);
    }

    public void watchThreadsPoll(PreferenceChangeListener pcl) {
        this.addListener(INT_KEY_THREADS_POLL, pcl);
    }

    public int getMonitoredDataPoll() {
        return this.getPollingInterval(INT_KEY_MONDATA_POLL, 1);
    }

    public void setMonitoredDataPoll(int value) {
        this.setPollingInterval(INT_KEY_MONDATA_POLL, value);
    }

    public void watchMonitoredDataPoll(PreferenceChangeListener pcl) {
        this.addListener(INT_KEY_MONDATA_POLL, pcl);
    }

    public int getMonitoredHostCache() {
        return this.getPollingInterval(INT_KEY_MONHOST_CACHE, 60);
    }

    public void setMonitoredHostCache(int value) {
        this.setPollingInterval(INT_KEY_MONHOST_CACHE, value);
    }

    public void watchMonitoredHostCache(PreferenceChangeListener pcl) {
        this.addListener(INT_KEY_MONHOST_CACHE, pcl);
    }

    public int getMonitoredDataCache() {
        return this.getPollingInterval(INT_KEY_MONDATA_CACHE, 60);
    }

    public void setMonitoredDataCache(int value) {
        this.setPollingInterval(INT_KEY_MONDATA_CACHE, value);
    }

    public void watchMonitoredDataCache(PreferenceChangeListener pcl) {
        this.addListener(INT_KEY_MONDATA_CACHE, pcl);
    }

    public boolean store() {
        try {
            this.prefs.sync();
            return true;
        }
        catch (BackingStoreException ex) {
            LOGGER.log(Level.SEVERE, "Error saving preferences", ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(String property, PreferenceChangeListener pcl) {
        Map<String, Set<ComparableWeakReference<PreferenceChangeListener>>> map = this.listenerMap;
        synchronized (map) {
            if (this.listenerMap.containsKey(property)) {
                Set<ComparableWeakReference<PreferenceChangeListener>> set = this.listenerMap.get(property);
                set.add(new ComparableWeakReference<PreferenceChangeListener>(pcl));
            } else {
                HashSet<ComparableWeakReference<PreferenceChangeListener>> set = new HashSet<ComparableWeakReference<PreferenceChangeListener>>();
                set.add(new ComparableWeakReference<PreferenceChangeListener>(pcl));
                this.listenerMap.put(property, set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPollingInterval(String property, int deflt) {
        int value = -1;
        Preferences preferences = this.prefs;
        synchronized (preferences) {
            value = this.prefs.getInt(property, -1);
            if (value == -1) {
                value = deflt;
                this.prefs.putInt(property, value);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPollingInterval(String property, int value) {
        Preferences preferences = this.prefs;
        synchronized (preferences) {
            this.prefs.putInt(property, value);
        }
    }
}

