/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.internal;

import com.jrockit.mc.rjmx.internal.KnownObjectNames;
import com.jrockit.mc.rjmx.internal.RJMXConnection;
import com.jrockit.mc.rjmx.internal.StandardNotificationListener;
import com.jrockit.mc.rjmx.subscription.IMBeanServerChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanInfo;

class MBeanServerChangeListenerCollection {
    private final RJMXConnection m_connection;
    private final Logger m_logger;
    private final Map<IMBeanServerChangeListener, StandardNotificationListener> m_listeners;

    public MBeanServerChangeListenerCollection(RJMXConnection connection, Logger logger) {
        this.m_connection = connection;
        this.m_logger = logger;
        this.m_listeners = new HashMap<IMBeanServerChangeListener, StandardNotificationListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpNotifications() {
        Map<IMBeanServerChangeListener, StandardNotificationListener> map = this.m_listeners;
        synchronized (map) {
            for (StandardNotificationListener listener : this.m_listeners.values()) {
                listener.unregister(this.m_logger);
            }
            this.m_listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMBeanServerChangeListener(IMBeanServerChangeListener callback) {
        Map<IMBeanServerChangeListener, StandardNotificationListener> map = this.m_listeners;
        synchronized (map) {
            StandardNotificationListener listener = this.m_listeners.remove(callback);
            if (listener != null) {
                listener.unregister(this.m_logger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMBeanServerChangeListener(IMBeanServerChangeListener callback) {
        try {
            MBeanInfo info = this.m_connection.getMBeanInfo(KnownObjectNames.MBEAN_NOTIFICATION_OBJECT_NAME);
            if (info == null) {
                return;
            }
            StandardNotificationListener listener = new StandardNotificationListener(this.m_connection.getMBeanServer(), callback);
            Map<IMBeanServerChangeListener, StandardNotificationListener> map = this.m_listeners;
            synchronized (map) {
                this.m_listeners.put(callback, listener);
            }
        }
        catch (Exception e) {
            this.m_logger.log(Level.WARNING, "Could not add notification listener for MBean changes - are you running against a 1.4 version?", e);
        }
    }
}

