/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.ui.UIPlugin;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;

final class UnknownComponentPainter
implements PaintListener {
    private final FormColors m_colors = ComponentsPlugin.getDefault().getFormColors(Display.getCurrent());
    private ComponentTypeDescriptor m_typeDescriptor;
    private Canvas m_canvas;

    UnknownComponentPainter() {
    }

    public void setCanvas(Canvas canvas) {
        this.m_canvas = canvas;
    }

    public void paintControl(PaintEvent e) {
        Display display = e.display;
        GC gc = e.gc;
        Rectangle rec = this.drawBackground(display, gc);
        if (this.m_typeDescriptor != null) {
            this.drawTypeDescriptor(gc, rec);
        } else {
            gc.drawString("Unknown Component", 5, 5);
        }
    }

    private Rectangle drawBackground(Display display, GC gc) {
        UIPlugin.getDefault().getFormColors(display);
        gc.setBackground(this.m_colors.getBackground());
        gc.setForeground(this.m_colors.getForeground());
        Rectangle rec = this.createInset(this.m_canvas.getClientArea());
        gc.fillRectangle(rec);
        gc.drawRectangle(rec);
        return rec;
    }

    private void drawTypeDescriptor(GC gc, Rectangle rec) {
        int width = rec.width - 1;
        int height = rec.height - 11;
        if (this.m_typeDescriptor.getIcon() != null) {
            gc.drawImage(this.m_typeDescriptor.getIcon(), 0, 0, 16, 16, width / 2 - 8, height / 2 - 8, 16, 16);
        }
        if (this.m_typeDescriptor.getName() != null) {
            gc.drawString(this.m_typeDescriptor.getName(), 5, 5);
        }
        if (this.m_typeDescriptor.getDescription() != null) {
            this.m_canvas.setToolTipText(this.m_typeDescriptor.getDescription());
        }
    }

    private Rectangle createInset(Rectangle rect) {
        Rectangle rectangle = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        rectangle.width = Math.max(rectangle.width - 1, 0);
        rectangle.height = Math.max(rectangle.height - 1, 0);
        return rectangle;
    }

    public void setTypeDescriptor(ComponentTypeDescriptor c) {
        this.m_typeDescriptor = c;
    }
}

